/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.parser.nodes;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.html.parsing.HTMLParseState;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.editor.html.parsing.ast.HTMLTextNode;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.parser.nodes.IPHPParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPBaseParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPBlockNode;
import com.aptana.editor.php.internal.parser.nodes.PHPCatchNode;
import com.aptana.editor.php.internal.parser.nodes.PHPClassParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPConstantNode;
import com.aptana.editor.php.internal.parser.nodes.PHPDoNode;
import com.aptana.editor.php.internal.parser.nodes.PHPExtendsNode;
import com.aptana.editor.php.internal.parser.nodes.PHPForNode;
import com.aptana.editor.php.internal.parser.nodes.PHPFunctionParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPHTMLNode;
import com.aptana.editor.php.internal.parser.nodes.PHPIfElseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPIncludeNode;
import com.aptana.editor.php.internal.parser.nodes.PHPNamespaceNode;
import com.aptana.editor.php.internal.parser.nodes.PHPSwitchCaseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPSwitchNode;
import com.aptana.editor.php.internal.parser.nodes.PHPTraitParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPTryNode;
import com.aptana.editor.php.internal.parser.nodes.PHPUseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPVariableParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPWhileNode;
import com.aptana.editor.php.internal.parser.nodes.Parameter;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.ast.ParseNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.Plugin;
import org2.eclipse.php.internal.core.ast.nodes.Identifier;
import org2.eclipse.php.internal.core.documentModel.phpElementData.IPHPDocBlock;

public class NodeBuilder {
    private IPHPParseNode current;
    private IPHPParseNode root;
    private Stack<Object> stack = new Stack();
    private List<Object> phpStarts = new ArrayList<Object>();
    private List<Object> phpEnds = new ArrayList<Object>();
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private boolean collectVariables = false;
    private boolean hasSyntaxErrors;
    private String source;
    private boolean parseHTML;

    public boolean hasSyntaxErrors() {
        return this.hasSyntaxErrors;
    }

    public NodeBuilder(String source, IPHPParseNode root) {
        this.source = source;
        this.current = root;
        this.root = root;
        this.parseHTML = true;
    }

    public NodeBuilder(String source) {
        this(source, new PHPBaseParseNode(0, 0, 0, 0, ""));
    }

    public NodeBuilder(String source, boolean collectVariables, boolean parseHTML) {
        this(source);
        this.collectVariables = collectVariables;
        this.parseHTML = parseHTML;
    }

    public void handleClassConstDeclaration(String constName, IPHPDocBlock docInfo, int startPosition, int endPosition, int stopPosition) {
        PHPVariableParseNode pn = new PHPVariableParseNode(0, startPosition, endPosition, constName);
        pn.setField(true);
        this.current.addChild(pn);
    }

    public void handleUse(String useName, String useAs, int startPosition, int stopPosition) {
        PHPUseNode un = new PHPUseNode(startPosition, stopPosition, useName, "use");
        un.setNameNode(useName, startPosition, stopPosition);
        this.current.addChild(un);
    }

    public void handleNamespaceDeclaration(String namespaceName, int startPosition, int endPosition, int stopPosition) {
        PHPNamespaceNode un = new PHPNamespaceNode(startPosition, endPosition, namespaceName, "");
        un.setNameNode(namespaceName, startPosition, stopPosition);
        this.pushNode(un);
    }

    public void handleClassDeclaration(String className, int modifier, IPHPDocBlock docInfo, int startPosition, int endPosition, int lineNumber) {
        PHPClassParseNode pn = new PHPClassParseNode(modifier, startPosition, endPosition, className);
        if (docInfo != null) {
            pn.setDocumentation(docInfo);
        }
        this.pushNode(pn);
    }

    public void handleTraitDeclaration(String traitName, int modifier, IPHPDocBlock docInfo, int startPosition, int endPosition, int lineNumber) {
        PHPTraitParseNode pn = new PHPTraitParseNode(modifier, startPosition, endPosition, traitName);
        if (docInfo != null) {
            pn.setDocumentation(docInfo);
        }
        this.pushNode(pn);
    }

    public void handleSuperclass(String superClassName, int startPosition, int endPosition) {
        if (superClassName != null) {
            String decodeClassName = this.decodeClassName(superClassName);
            PHPClassParseNode classNode = (PHPClassParseNode)this.current;
            classNode.setSuperClassName(decodeClassName);
            PHPExtendsNode superClass = new PHPExtendsNode(0, startPosition, endPosition, decodeClassName);
            superClass.setNameNode(decodeClassName, startPosition, endPosition);
            classNode.addChild(superClass);
        }
    }

    public void handleTraitSuperclass(String superClassName, int startPosition, int endPosition) {
        if (superClassName != null) {
            String decodeClassName = this.decodeClassName(superClassName);
            PHPTraitParseNode traitNode = (PHPTraitParseNode)this.current;
            traitNode.setSuperClassName(decodeClassName);
            PHPExtendsNode superClass = new PHPExtendsNode(0, startPosition, endPosition, decodeClassName);
            superClass.setNameNode(decodeClassName, startPosition, endPosition);
            traitNode.addChild(superClass);
        }
    }

    public void handleImplements(String[] interfacesNames, int[][] startEndPositions) {
        if (interfacesNames != null && interfacesNames.length > 0 && startEndPositions != null) {
            PHPClassParseNode classNode = (PHPClassParseNode)this.current;
            ArrayList<String> interfaces = new ArrayList<String>(interfacesNames.length);
            int i = 0;
            while (i < interfacesNames.length) {
                String interfaceName = this.decodeClassName(interfacesNames[i]);
                interfaces.add(interfaceName);
                classNode.addChild(new PHPExtendsNode(8, startEndPositions[i][0], startEndPositions[i][1], interfaceName));
                ++i;
            }
            classNode.setInterfaces(interfaces);
        }
    }

    private void pushNode(PHPBaseParseNode pn) {
        this.current.addChild(pn);
        this.stack.push(this.current);
        this.current = pn;
    }

    public void handleClassVariablesDeclaration(String variables, int modifier, IPHPDocBlock docInfo, int startPosition, int endPosition, int stopPosition) {
        PHPVariableParseNode pn = new PHPVariableParseNode(modifier, startPosition, endPosition, variables);
        pn.setField(true);
        this.current.addChild(pn);
        pn.setNameNode(variables, startPosition, endPosition);
    }

    public void handleVariableName(String variableName, int line) {
        if (this.collectVariables && this.current == this.root) {
            PHPVariableParseNode pn = new PHPVariableParseNode(0, -1, -1, variableName);
            pn.setField(false);
            pn.setLocalVariable(false);
            pn.setParameter(false);
            this.current.addChild(pn);
        }
    }

    public void handleDefine(String name, String value, IPHPDocBlock docInfo, int startPosition, int endPosition, int stopPosition) {
        PHPConstantNode pn = new PHPConstantNode(startPosition, endPosition, name);
        pn.setDocumentation(docInfo);
        pn.setField(true);
        pn.setNameNode(name, startPosition, endPosition);
        this.current.addChild(pn);
    }

    public void handleError(String description, int startPosition, int endPosition, int lineNumber) {
        IdeLog.logInfo((Plugin)PHPEditorPlugin.getDefault(), (String)("NodeBuilderClient.handleError() --> " + description), null, (String)"com.aptana.editor.php/debug");
    }

    public void handleFunctionDeclaration(String functionName, boolean isClassFunction, int modifier, IPHPDocBlock docInfo, int startPosition, int stopPosition, int lineNumber) {
        PHPFunctionParseNode pn = new PHPFunctionParseNode(modifier, startPosition, stopPosition, functionName);
        pn.setMethod(isClassFunction);
        pn.setParameters(this.parameters);
        if (docInfo != null) {
            pn.setDocumentation(docInfo);
        }
        this.parameters = new ArrayList<Parameter>();
        this.pushNode(pn);
    }

    public void handleFunctionParameter(String classType, String variableName, boolean isReference, boolean isConst, String defaultValue, int startPosition, int endPosition, int stopPosition, int lineNumber) {
        Parameter pr = new Parameter(classType, variableName, defaultValue, isReference, isConst);
        this.parameters.add(pr);
    }

    public void handleGlobalVar(String variableName) {
        PHPVariableParseNode pn = new PHPVariableParseNode(0, -1, -1, variableName);
        this.current.addChild(pn);
    }

    public void handlePHPStart(int startOffset, int endOffset) {
        this.phpStarts.add(new Integer(startOffset));
    }

    public void handlePHPEnd(int startOffset, int endOffset) {
        this.phpEnds.add(new Integer(startOffset));
    }

    public void handleStaticVar(String variableName) {
        PHPVariableParseNode pn = new PHPVariableParseNode(1, -1, -1, variableName);
        this.current.addChild(pn);
    }

    public PHPBlockNode populateNodes() {
        PHPBlockNode bn = new PHPBlockNode(0, 0, "php");
        int a = 0;
        while (a < this.current.getChildCount()) {
            bn.addChild(this.current.getChild(a));
            ++a;
        }
        if (this.parseHTML) {
            this.replaceHtmlNodes(bn);
        }
        return bn;
    }

    private void replaceHtmlNodes(IParseNode pn) {
        IParseRootNode htmlParseResult = null;
        try {
            HTMLParseState parseState = new HTMLParseState(this.source);
            htmlParseResult = ParserPoolFactory.parse((String)"com.aptana.contenttype.html", (IParseState)parseState).getRootNode();
        }
        catch (Exception e) {
            IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"A problem while integrating the HTML parse result nodes into the PHP parse result nodes", (Throwable)e);
        }
        this.integrateNodesRecursively(pn, this.mapHTMLElementNodes(htmlParseResult.getChildren()));
    }

    /*
     * Unable to fully structure code
     */
    private void integrateNodesRecursively(IParseNode phpParseNode, Map<Integer, HTMLElementNode> htmlElementNodes) {
        queue = new LinkedList<IParseNode>();
        htmlNode = null;
        var8_5 = phpParseNode.getChildren();
        var7_6 = var8_5.length;
        var6_7 = 0;
        while (var6_7 < var7_6) {
            node = var8_5[var6_7];
            if (htmlNode == null) ** GOTO lbl16
            if (htmlNode.contains(node.getStartingOffset())) {
                if (node.getNodeType() != 4509) {
                    this.repositionNode((ParseNode)node, htmlNode);
                    queue.offer(node);
                }
            } else {
                htmlNode = null;
lbl16:
                // 2 sources

                if (node.getNodeType() == 4509) {
                    offset = node.getStartingOffset();
                    while (offset < node.getEndingOffset()) {
                        if (!Character.isWhitespace(this.source.charAt(offset))) break;
                        ++offset;
                    }
                    htmlNode = htmlElementNodes.get(offset);
                    if (htmlNode != null) {
                        parent = node.getParent();
                        while (parent != null && parent.isFilteredFromOutline() && parent.getNodeType() != 4504) {
                            node = parent;
                            parent = node.getParent();
                        }
                        if (parent != null) {
                            nextSibling = htmlNode.getNextSibling();
                            toInsert = new HashSet<Object>();
                            toInsert.add(htmlNode);
                            while (nextSibling != null && nextSibling.getStartingOffset() < node.getEndingOffset()) {
                                if (nextSibling instanceof HTMLElementNode && !toInsert.add(nextSibling)) break;
                                nextSibling = nextSibling.getNextSibling();
                            }
                            nodeIndex = node.getIndex();
                            if (nodeIndex > -1 && parent.getChildCount() > nodeIndex) {
                                var18_21 = children = parent.getChildren();
                                var17_20 = children.length;
                                var16_19 = 0;
                                while (var16_19 < var17_20) {
                                    child = var18_21[var16_19];
                                    if (toInsert.contains(child)) {
                                        toInsert.remove(child);
                                    }
                                    ++var16_19;
                                }
                                siblingsCount = toInsert.size();
                                newChildren = new IParseNode[children.length + siblingsCount];
                                System.arraycopy(children, 0, newChildren, 0, nodeIndex);
                                System.arraycopy(toInsert.toArray(), 0, newChildren, nodeIndex, siblingsCount);
                                System.arraycopy(children, nodeIndex, newChildren, siblingsCount + nodeIndex, newChildren.length - nodeIndex - siblingsCount);
                                ((ParseNode)parent).setChildren(newChildren);
                            }
                        }
                    }
                } else {
                    queue.offer(node);
                }
            }
            ++var6_7;
        }
        for (IParseNode node : queue) {
            this.integrateNodesRecursively(node, htmlElementNodes);
        }
    }

    private void repositionNode(ParseNode phpNode, HTMLElementNode newHtmlParent) {
        IParseNode closesedHTMLNode;
        IParseNode phpNodeParent = phpNode.getParent();
        int phpNodeIndex = phpNode.getIndex();
        if (newHtmlParent.getParent() != phpNodeParent) {
            newHtmlParent.setParent(phpNodeParent);
            phpNodeParent.replaceChild(phpNodeIndex, (IParseNode)newHtmlParent);
        }
        if ((closesedHTMLNode = newHtmlParent.getNodeAtOffset(phpNode.getStartingOffset())).getParent() instanceof HTMLElementNode) {
            newHtmlParent = (HTMLElementNode)closesedHTMLNode.getParent();
        }
        phpNode.setParent((IParseNode)newHtmlParent);
        IParseNode[] htmlChildren = newHtmlParent.getChildren();
        LinkedHashSet<Object> newChildren = new LinkedHashSet<Object>(htmlChildren.length);
        boolean phpChildInserted = false;
        IParseNode[] iParseNodeArray = htmlChildren;
        int n = htmlChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode child = iParseNodeArray[n2];
            if (!phpChildInserted && child.contains(phpNode.getStartingOffset()) && child instanceof HTMLTextNode) {
                newChildren.add(phpNode);
                phpChildInserted = true;
            } else if (phpChildInserted) {
                if (!phpNode.contains(child.getStartingOffset())) {
                    newChildren.add(child);
                }
            } else {
                newChildren.add(child);
            }
            ++n2;
        }
        htmlChildren = newChildren.toArray(new IParseNode[newChildren.size()]);
        newHtmlParent.setChildren(htmlChildren);
        IParseNode[] phpChildren = phpNodeParent.getChildren();
        IParseNode[] newPhpChildren = new IParseNode[phpChildren.length - 1];
        System.arraycopy(phpChildren, 0, newPhpChildren, 0, phpNodeIndex);
        System.arraycopy(phpChildren, phpNodeIndex + 1, newPhpChildren, phpNodeIndex, phpChildren.length - phpNodeIndex - 1);
        ((ParseNode)phpNodeParent).setChildren(newPhpChildren);
    }

    private Map<Integer, HTMLElementNode> mapHTMLElementNodes(IParseNode[] parseNodes) {
        HashMap<Integer, HTMLElementNode> offsetToNode = new HashMap<Integer, HTMLElementNode>();
        IParseNode[] iParseNodeArray = parseNodes;
        int n = parseNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode child = iParseNodeArray[n2];
            if (child instanceof HTMLElementNode) {
                HTMLElementNode previous = offsetToNode.put(child.getStartingOffset(), (HTMLElementNode)child);
                if (previous != null) {
                    IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Invalid HTML parse result structure");
                    return offsetToNode;
                }
                offsetToNode.putAll(this.mapHTMLElementNodes(child.getChildren()));
            }
            ++n2;
        }
        return offsetToNode;
    }

    public void handleIncludedFile(String includingType, String includeFileName, IPHPDocBlock docInfo, int startPosition, int endPosition, int stopPosition, int lineNumber) {
        PHPIncludeNode node = new PHPIncludeNode(startPosition, endPosition, includeFileName, includingType);
        node.setNameNode(includeFileName, startPosition, endPosition);
        this.current.addChild(node);
    }

    private String decodeClassName(String encodedName) {
        int bracketIndex = encodedName.indexOf(93);
        if (bracketIndex == -1 || bracketIndex == encodedName.length() - 1) {
            return encodedName;
        }
        return encodedName.substring(bracketIndex + 1);
    }

    public void handleSyntaxError(int currToken, String currText, short[] rowOfProbe, int startPosition, int endPosition, int lineNumber) {
        this.hasSyntaxErrors = true;
    }

    public void setNodeName(Identifier nameIdentifier) {
        if (this.current != null && nameIdentifier != null) {
            this.current.setNameNode(nameIdentifier.getName(), nameIdentifier.getStart(), nameIdentifier.getEnd() - 1);
        } else if (nameIdentifier == null) {
            IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"PHP NodeBuilder.setNodeName got a null identifier.", (String)"com.aptana.editor.php/debug");
        } else {
            IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"PHP NodeBuilder.setNodeName didn't hold any current node to set a name on.", (String)"com.aptana.editor.php/debug");
        }
    }

    public void handleCommonDeclarationEnd() {
        try {
            this.current = (IPHPParseNode)this.stack.pop();
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error building the PHP nodes.", (Throwable)e);
        }
    }

    public void handleInlineHtml(int start, int end) {
        this.handlePHPEnd(start, -1);
        this.handlePHPStart(end, -1);
        if (this.current.getChildCount() > 0 && this.current.getLastChild().getNodeType() == 4509) {
            PHPBaseParseNode lastChild = (PHPBaseParseNode)this.current.getLastChild();
            lastChild.setLocation(lastChild.getStart(), end);
        } else {
            this.current.addChild(new PHPHTMLNode(start, end));
        }
    }

    public void handleTryStatement(int start, int end) {
        this.pushNode(new PHPTryNode(start, end));
    }

    public void handleCatchStatement(int start, int end) {
        this.pushNode(new PHPCatchNode(start, end));
    }

    public void handleDoStatement(int start, int end) {
        this.pushNode(new PHPDoNode(start, end));
    }

    public void handleForStatement(int start, int end) {
        this.pushNode(new PHPForNode(start, end, PHPForNode.FOR_TYPE.FOR));
    }

    public void handleForEachStatement(int start, int end) {
        this.pushNode(new PHPForNode(start, end, PHPForNode.FOR_TYPE.FOREACH));
    }

    public void handleSwitchCaseStatement(int start, int end) {
        this.pushNode(new PHPSwitchCaseNode(start, end));
    }

    public void handleSwitchStatement(int start, int end) {
        this.pushNode(new PHPSwitchNode(start, end));
    }

    public void handleWhileStatement(int start, int end) {
        this.pushNode(new PHPWhileNode(start, end));
    }

    public void handleIfElseStatement(int start, int end, String type) {
        this.pushNode(new PHPIfElseNode(start, end, type));
    }
}

